/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.bootstrap;

import com.alibaba.nacos.NacosServerBasicApplication;
import com.alibaba.nacos.NacosServerWebApplication;
import com.alibaba.nacos.bootstrap.NacosBootstrap;
import com.alibaba.nacos.console.NacosConsole;
import com.alibaba.nacos.core.listener.startup.NacosStartUpManager;
import com.alibaba.nacos.sys.env.DeploymentType;
import com.alibaba.nacos.sys.env.EnvUtil;
import org.springframework.boot.Banner;
import org.springframework.boot.ResourceBanner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.support.RegistrationPolicy;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
public class NacosBootstrap {
    private static final String SPRING_JXM_ENABLED = "spring.jmx.enabled";

    public static void main(String[] args) {
        String type = System.getProperty("nacos.deployment.type", "merged");
        DeploymentType deploymentType = DeploymentType.getType((String)type);
        EnvUtil.setDeploymentType((DeploymentType)deploymentType);
        switch (1.$SwitchMap$com$alibaba$nacos$sys$env$DeploymentType[deploymentType.ordinal()]) {
            case 1: {
                NacosBootstrap.startWithConsole((String[])args);
                break;
            }
            case 2: {
                NacosBootstrap.startWithoutConsole((String[])args);
                break;
            }
            case 3: {
                NacosBootstrap.startOnlyConsole((String[])args);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported nacos deployment type " + type);
            }
        }
    }

    private static void prepareCoreContext(ConfigurableApplicationContext coreContext) {
        if (((Boolean)coreContext.getEnvironment().getProperty("spring.jmx.enabled", Boolean.class, (Object)false)).booleanValue()) {
            ((MBeanExporter)coreContext.getBean(MBeanExporter.class)).setRegistrationPolicy(RegistrationPolicy.IGNORE_EXISTING);
        }
    }

    private static void startWithoutConsole(String[] args) {
        ConfigurableApplicationContext coreContext = NacosBootstrap.startCoreContext((String[])args);
        NacosBootstrap.prepareCoreContext((ConfigurableApplicationContext)coreContext);
        ConfigurableApplicationContext webContext = NacosBootstrap.startServerWebContext((String[])args, (ConfigurableApplicationContext)coreContext);
    }

    private static void startWithConsole(String[] args) {
        ConfigurableApplicationContext coreContext = NacosBootstrap.startCoreContext((String[])args);
        NacosBootstrap.prepareCoreContext((ConfigurableApplicationContext)coreContext);
        ConfigurableApplicationContext serverWebContext = NacosBootstrap.startServerWebContext((String[])args, (ConfigurableApplicationContext)coreContext);
        ConfigurableApplicationContext consoleContext = NacosBootstrap.startConsoleContext((String[])args, (ConfigurableApplicationContext)coreContext);
    }

    private static ConfigurableApplicationContext startCoreContext(String[] args) {
        NacosStartUpManager.start((String)"core");
        return new SpringApplicationBuilder(new Class[]{NacosServerBasicApplication.class}).web(WebApplicationType.NONE).banner(NacosBootstrap.getBanner((String)"core-banner.txt")).run(args);
    }

    private static ConfigurableApplicationContext startServerWebContext(String[] args, ConfigurableApplicationContext coreContext) {
        NacosStartUpManager.start((String)"web");
        return new SpringApplicationBuilder(new Class[]{NacosServerWebApplication.class}).parent(coreContext).banner(NacosBootstrap.getBanner((String)"nacos-server-web-banner.txt")).run(args);
    }

    private static ConfigurableApplicationContext startConsoleContext(String[] args, ConfigurableApplicationContext coreContext) {
        NacosStartUpManager.start((String)"console");
        return new SpringApplicationBuilder(new Class[]{NacosConsole.class}).parent(coreContext).banner(NacosBootstrap.getBanner((String)"nacos-console-banner.txt")).run(args);
    }

    private static void startOnlyConsole(String[] args) {
        NacosStartUpManager.start((String)"console");
        ConfigurableApplicationContext consoleContext = new SpringApplicationBuilder(new Class[]{NacosConsole.class}).banner(NacosBootstrap.getBanner((String)"nacos-console-banner.txt")).run(args);
    }

    private static Banner getBanner(String bannerFileName) {
        return new ResourceBanner((Resource)new ClassPathResource(bannerFileName));
    }
}

